﻿package {
	import flash.events.*;
	import flash.display.*;
	import flash.text.*;
	import flash.ui.ContextMenu;
	import flash.ui.ContextMenuItem;
	
	public class Category extends MovieClip{
		public var objData:Object;
		public var numItems:Number = 0;
		public var order:Number = 0;
		public var dispatcher = new EventDispatcher();
		
		public var permission_nodelete:Boolean = false;
		public var permission_noupdate:Boolean = false;
		public var permission_noadditems:Boolean = false;
		public var hidden:Boolean = false;		
		public var placex,placey;
		public var flagSelected = false;
		public var flagMouseOver = false;	//tells that the category is mouse overed.
		public var flagContextClick = false;	//flag on click context item (for mouseoverborder)
		public var mode:String = "normal";
		public var flagStageEvent:Boolean = false;	//stage event flag.
		public var flagInputClick:Boolean = false;	//catch input box click
		public var lastTimeClicked:Number = 0;
		
		//visible properties:
		//txt_category
		//mc_buttonDelete
		//mc_buttonEdit
		//mc_dragButton
		//mc_mouseOverBorder
		
		//constructor:
		public function Category(){
			setContextMenu();
			this.mc_mouseOverBorder.visible = false;
			mc_dragButton.doubleClickEnabled = true;
			mc_dragButton.addEventListener(MouseEvent.MOUSE_DOWN, dragButtonMouseDown);
			mc_dragButton.addEventListener(MouseEvent.MOUSE_UP, dragButtonMouseUp);
			mc_dragButton.addEventListener(MouseEvent.MOUSE_DOWN, onCatClick);
			
			this.addEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
			this.addEventListener(MouseEvent.MOUSE_OUT,onMouseOut);			
			this.input_name.visible = false;
		}
		
		//--------------------------------------------------------
		// set context menu for category object
		public function setContextMenu(){
			var menu:ContextMenu = new ContextMenu();
			
			menu.addEventListener(ContextMenuEvent.MENU_SELECT,onContextMenuApear);
			
			//add category
			var	itemAddCategory:ContextMenuItem = new ContextMenuItem("Add new category");
			var	itemDeleteCategory:ContextMenuItem = new ContextMenuItem("Delete category");
			var	itemEditName:ContextMenuItem = new ContextMenuItem("Edit title");			
			var	itemEditCategory:ContextMenuItem = new ContextMenuItem("Edit category");
						
			//button events.
			itemEditName.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onEditNameClick);
			itemAddCategory.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onAddCategoryClick);
			itemDeleteCategory.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onDeleteCategoryClick);
			itemEditCategory.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT,onEditCategoryClick);
			
			//set input events:
			this.input_name.addEventListener(KeyboardEvent.KEY_DOWN,onInputNameKeyDown);
			this.input_name.addEventListener(MouseEvent.MOUSE_DOWN,onInputNameMouseDown);
			
			menu.customItems.push(itemEditName);
			menu.customItems.push(itemEditCategory);
			menu.customItems.push(itemDeleteCategory);
			menu.customItems.push(itemAddCategory);
			
			menu.hideBuiltInItems();
			this.contextMenu = menu;
		}

      	  //-------------------------------------------------------------------------
		  // event when appears context menu.
		  public function onContextMenuApear(event:ContextMenuEvent){
			  this.flagContextClick = true;
		  }
		  
	      //-------------------------------------------------------------------------
		  //event on click edit name menu item. switch to edit name mode.
		  public function onEditNameClick(event:ContextMenuEvent){
			  changeToEditMode(false);
		  }
		 
	      //-------------------------------------------------------------------------
		  //call parent (categories panel to trigger event of adding a new categroy
		  public function onAddCategoryClick(event:ContextMenuEvent){
			  var catHolder = this.parent;
			  catHolder.triggerAddNewCategoryEvent();
		  }
		  
	      //-------------------------------------------------------------------------
		  //edit category click. 
		  public function onEditCategoryClick(event:ContextMenuEvent){
			  editCategoryRequest();
		  }
				  
	      //-------------------------------------------------------------------------
		  // delete category click event. show confirm dialog
		  public function onDeleteCategoryClick(event:ContextMenuEvent){
			  deleteCategoryRequest();
		  }
		  
	      //-------------------------------------------------------------------------
		  // on category double click
		  public function onCatDoubleClick(){
			  editCategoryRequest();
		  }
		  
	      //-------------------------------------------------------------------------
		  // category on click event. calculate double click
		  private function onCatClick(event:MouseEvent){
			  var date = new Date();
			  var stamp = date.getTime();
			  if(stamp - this.lastTimeClicked <= 500) onCatDoubleClick();
			  this.lastTimeClicked = stamp;
		  }
		  
	      //-------------------------------------------------------------------------
		  // tell website object toopen edit category dialog
		  public function editCategoryRequest(){
			  var website = this.parent.parent.parent;
			  website.showEditCategoryDialog(this.objData);
		  }
		  
	      //-------------------------------------------------------------------------
		  // delete category request. show confirm dialog for deleting category.
		  public function deleteCategoryRequest(){
			  var website = this.parent.parent.parent;
			  website.showConfirmDialogStoreData("deleteCategory","Do you want to delete \""+this.objData.title+"\" category with all it's items?",this.objData.id);
		  }
		  
	      //-------------------------------------------------------------------------
		  // input box click. remember the click for stage click event.
		  private function onInputNameMouseDown(event:MouseEvent){
			  this.flagInputClick = true;
		  }
		  		  
	      //-------------------------------------------------------------------------
		  // input box key down. exit edit mode, and save name
		  public function onInputNameKeyDown(event:KeyboardEvent){
			  switch(event.keyCode){
				  case 13:	//enter - close edit mode with saving
				  	endEditMode(true);
				  break;
				  case 27:	//escape - close edit mode without saving.
				  	endEditMode(false);
				  break;
			  }
		  }
		
	      //-------------------------------------------------------------------------
		  //switch edit item mode.
		  public function changeToEditMode(preventStageEvent:Boolean){
			  //check permission and type
			  var website = this.parent.parent.parent;
			  
			  //validate permissions
			  if(this.permission_noupdate == true){
				  website.showDialog("textonly","","Sorry, but category: \""+this.objData.title+"\" is not editable.");
				  return(false);
			  }
			  
			  //prevent stage event
			  if(preventStageEvent == true) this.flagInputClick = true; //prevent stage event to take place.
			  
			  //hide all elements that interfering the editing.
			  this.mc_dragButton.visible = false;
			  
			  //set stage mouse down event
			  if(stage !== null && this.flagStageEvent == false){
				  stage.addEventListener(MouseEvent.MOUSE_DOWN,onStageMouseDown);
				  flagStageEvent = true;
			  }
			  
			  this.mode = "editName";
			  this.input_name.visible = true;
			  this.input_name.text = this.objData.title;
			  this.input_name.setFocus();
			  this.txt_name.visible = false;
		  }
		  		  
		  
	      //-------------------------------------------------------------------------
		  //end edit mode. if there is a changes, save them.
		  public function endEditMode(toSave:Boolean){
			  //this.mouseChildren = false;			  
			  if(this.mode == "normal") return(false);
			  this.mc_dragButton.visible = true;
			  
			  switch(mode){
				  case "editName":
					this.mode = "normal";
				  	this.input_name.visible = false;
					this.txt_name.visible = true;
					
					if(toSave == true && input_name.text != this.objData.title){
						this.txt_name.text = this.input_name.text;
						this.objData.title = this.input_name.text;
						setCatNameText();
						
						//call website to save the changes on server
						var website = this.parent.parent.parent;
						website.updateCategory(this.objData);
					}					
				  break;
			  }
		  }		
		
		//----------------------------------------------------------------------------------------
		//category stage mouse down event.
		private function onStageMouseDown(event:MouseEvent){
			  if(this.flagInputClick == true){
				  this.flagInputClick = false;
				  return(false);
			  }
			  if(this.mode != "editName") return(false);
						  
			  endEditMode(true);			
		}
		
		//----------------------------------------------------------------------------------------
		//hide mouse over border
		public function hideOverBorder(){
			this.mc_mouseOverBorder.visible = false;
			this.flagMouseOver = false;
			var catHolder = this.parent;
			if(catHolder == null) return(false);
			catHolder.lastOverCategory = null;
		}
		
		//----------------------------------------------------------------------------------------
		//show mouse over border
		public function showOverBorder(){
			var catHolder = this.parent;
			catHolder.hideOverBorderFromLastCategory();
			
			this.mc_mouseOverBorder.visible = true;
			this.flagMouseOver = true;
			catHolder.lastOverCategory = this;
		}
		
		//----------------------------------------------------------------------------------------
		//on category mouse over event. show border, and check item dragging.
		public function onMouseOver(event:MouseEvent){
			showOverBorder();
		}

		//----------------------------------------------------------------------------------------
		//on mouse out - hide the border, and check mouse out.
		public function onMouseOut(event:MouseEvent){
		  if(this.flagContextClick == true){	//if context menu clicked - don't hide border
			  this.flagContextClick = false;
			  return(false);
		  }			
			hideOverBorder();
		}
		
		//----------------------------------------------------------------------------------------
		//set category selected
		public function setSelected(){
			this.flagSelected = true;
			this.gotoAndStop(2);
		}
		
		//----------------------------------------------------------------------------------------
		//set category selected
		public function setUnselected(){
			this.flagSelected = false;
			this.gotoAndStop(1);
		}
		
		//----------------------------------------------------------------------------------------
		//remember objcet position
		public function rememberPosition(){
			placex = this.x;
			placey = this.y;
		}
		
		//----------------------------------------------------------------------------------------
		//return to ladt remembered position
		public function returnToLastPosition(){
			this.x = placex;
			this.y = placey;
		}
		
		public function setPosition(x:Number,y:Number){
			this.placex = x;
			this.placey = y;
		}
		
		
		//----------------------------------------------------------------------------------------
		//update text. set text+number of items - if there is any.
		public function setCatNameText(){
			if(this.numItems > 0) this.txt_name.text = this.objData.title + "("+this.numItems+")";
			else this.txt_name.text = this.objData.title;
		}
		
		//----------------------------------------------------------------------------------------
		//set main category vars
		public function setData(objData:Object,numItems:Number,order:Number){
			this.objData = objData;
			this.numItems = numItems;
			this.order = order;
			setCatNameText();
		}
		
		//----------------------------------------------------------------------------------------
		//update category data
		public function updateData(objData1){
			for(var index in objData1){
				this.objData[index] = objData1[index];
			}
			setCatNameText();
		}
		
		//----------------------------------------------------------------------------------------
		//set permission and properties vars
		public function setProperties(permission_nodelete:Boolean,permission_noupdate:Boolean,permission_noadditems:Boolean,hidden:Boolean){
			this.permission_nodelete = permission_nodelete;
			this.permission_noupdate = permission_noupdate;
			this.permission_noadditems = permission_noadditems;
			this.hidden = hidden;
		}
		
		public function dragButtonMouseDown(event:MouseEvent){
			this.dispatcher.dispatchEvent(new TextEvent("dragMouseDown",false,false,this.objData.id));
		}
		
		public function dragButtonMouseUp(event:MouseEvent){
			this.dispatcher.dispatchEvent(new TextEvent("dragMouseUp",false,false,this.objData.id));
		}
		
		//----------------------------------------------------------------------------------------
		//update category name together with num items (if grater than 0)
		public function updateNumItemsDisplayText(){
			if(this.numItems > 0) txt_name.text = this.objData.title + "("+this.numItems+")";
			else txt_name.text = this.objData.title;
		}
				
		//----------------------------------------------------------------------------------------
		//update number of items and the category text
		public function updateNumItems(numItems:Number){
			this.numItems = numItems;
			updateNumItemsDisplayText();
		}
		
		//----------------------------------------------------------------------------------------
		//reduce from num items (in case of delete.
		public function reduceNumItems(numToReduce:Number){
			this.numItems -= numToReduce;
			if(this.numItems<0){
				trace("reduceFromNumItems error - the number of items cannot be below zero");
				this.numItems = 0;
			}
			updateNumItemsDisplayText();
		}
		
		//----------------------------------------------------------------------------------------
		//get category name
		public function getTitle(){
			return(this.objData.title);
		}
		
		public function getID(){
			return(this.objData.id);
		}
		
	}
}